/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.JOptionPane;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.Direct;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.model.GCodeSource;

public class ToRemoteFile
implements MachineBuilder {
    static Map<SDCardCapture.ResponseCode, String> sdErrorMap = new EnumMap<SDCardCapture.ResponseCode, String>(SDCardCapture.ResponseCode.class);
    Direct directBuilder;
    SDCardCapture sdcc;

    public boolean processSDResponse(SDCardCapture.ResponseCode code) {
        if (code == SDCardCapture.ResponseCode.SUCCESS) {
            return true;
        }
        String message = sdErrorMap.get((Object)code);
        JOptionPane.showMessageDialog(null, message, "SD card error", 0);
        return false;
    }

    public ToRemoteFile(Driver driver, SimulationDriver simulator, GCodeSource source, String remoteName) {
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_CARD, "No SD card was detected.  Please make sure you have a working, formatted\nSD card in the motherboard's SD slot and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_INIT, "ReplicatorG was unable to initialize the SD card.  Please make sure that\nthe SD card works properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_PARTITION, "ReplicatorG was unable to read the SD card's partition table.  Please check\nthat the card is partitioned properly.\nIf you believe your SD card is OK, try resetting your device and restarting\nReplicatorG.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_FS, "ReplicatorG was unable to open the filesystem on the SD card.  Please make sure\nthat the SD card has a single partition formatted with a FAT16 filesystem.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_ROOT_DIR, "ReplicatorG was unable to read the root directory on the SD card.  Please\ncheck to see if the SD card was formatted properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_LOCKED, "The SD card cannot be written to because it is locked.  Remove the card,\nswitch the lock off, and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_FILE, "ReplicatorG could not find the build file on the SD card.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_GENERIC, "Unknown SD card error.");
        this.sdcc = (SDCardCapture)((Object)driver);
        if (this.processSDResponse(this.sdcc.beginCapture(remoteName))) {
            this.directBuilder = new Direct(driver, simulator, source);
        }
    }

    @Override
    public boolean finished() {
        if (!this.directBuilder.finished()) {
            return false;
        }
        int totalBytes = this.sdcc.endCapture();
        Base.logger.info("Captured bytes: " + Integer.toString(totalBytes));
        return true;
    }

    @Override
    public void runNext() {
        this.directBuilder.runNext();
    }

    @Override
    public int getLinesTotal() {
        return this.directBuilder.getLinesTotal();
    }

    @Override
    public int getLinesProcessed() {
        return this.directBuilder.getLinesProcessed();
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.REMOTE_FILE;
    }
}

